/**
* \file: CProtocolFactory.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "CProtocolFactory.h"
#include "aoapSocket.h"
#include "eapSocket.h"
#include "CCarLifeLog.h"

LOG_IMPORT_CONTEXT(bdcl_core)
IProtocolSocketConnector* CProtocolFactory::protocolInstance = nullptr;

void* CProtocolFactory::getInstance(deviceType inType)
{
    if (inType == aoap_Device)
    {
        if (!protocolInstance)
        {
            CProtocolFactory::protocolInstance = new aoapSocket();
            LOG_INFO((bdcl_core,"Factory creats the aoapSocket"));
        }
    }
    else if (inType == ios_Device)
    {
        if (!protocolInstance)
        {
            CProtocolFactory::protocolInstance = new eapSocket();
            LOG_INFO((bdcl_core,"Factory creats the eapSocket"));
        }

    }
    return protocolInstance;
}
void CProtocolFactory::destroy()
{
    delete CProtocolFactory::protocolInstance;
    CProtocolFactory::protocolInstance = nullptr;
}
